package jamezo97.clonecraft.entity.clone;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumStatus;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class FakeEntityPlayer extends EntityPlayer{

	EntityClone clone;

	public FakeEntityPlayer(EntityClone clone){
		//TODO Add Clone.getname in here somewhere
		super(clone.worldObj, clone.name);
		this.clone = clone;
		//Should only have to set this once, as Object values are referenced by memory location, not value I'm pretty sure.
		this.inventory.mainInventory = clone.inventory.mainInventory;
		this.inventory.armorInventory = clone.inventory.armorInventory;
		
		this.yOffset = clone.yOffset;
	}


	@Override
	public String getCommandSenderName() {
		return clone.name;
	}


	@Override
	public void sendChatToPlayer(ChatMessageComponent chatmessagecomponent) {}

	@Override
	public boolean canCommandSenderUseCommand(int i, String s) {
		return false;
	}

	@Override
	public ChunkCoordinates getPlayerCoordinates(){
		return new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY + 0.5D), MathHelper.floor_double(this.posZ));
	}

	public void update(EntityClone clone) {
		setPositionAndRotation(clone.posX, clone.posY, clone.posZ, clone.rotationYaw, clone.rotationPitch);
		this.foodStats.setFoodLevel(clone.getFoodStats().getFoodLevel());
		this.foodStats.setFoodSaturationLevel(clone.getFoodStats().getSaturationLevel());
		this.yOffset = clone.yOffset;
	}

/*
	@Override
	protected void entityInit() {
		clone.entityInit();
	}*/


	@Override
	public ItemStack getItemInUse() {
		return clone.getItemInUse();
	}


	@Override
	public int getItemInUseCount() {
		return clone.getItemInUseCount();
	}


	@Override
	public boolean isUsingItem() {
		return clone.isUsingItem();
	}


	@Override
	public int getItemInUseDuration() {
		return clone.getItemInUseDuration();
	}


	@Override
	public void stopUsingItem() {
		clone.stopUsingItem();
	}


	@Override
	public void clearItemInUse() {
		clone.clearItemInUse();
	}

/*
	@Override
	public boolean isBlocking() {
		return clone.isBlocking();
	}*/


	@Override
	public void onUpdate() {
		clone.onUpdate();
	}


	@Override
	public int getMaxInPortalTime() {
		return clone.getMaxInPortalTime();
	}


	@Override
	public int getPortalCooldown() {
		return clone.getPortalCooldown();
	}


	@Override
	public void playSound(String par1Str, float par2, float par3) {
		clone.playSound(par1Str, par2, par3);
	}


	@Override
	protected void updateItemUse(ItemStack par1ItemStack, int par2) {
		clone.updateItemUse(par1ItemStack, par2);
	}


	@Override
	protected void onItemUseFinish() {
		clone.onItemUseFinish();
	}


	@Override
	public void handleHealthUpdate(byte par1) {
		clone.handleHealthUpdate(par1);
	}

/*
	@Override
	protected boolean isMovementBlocked() {
		return clone.isMovementBlocked();
	}


	@Override
	public void closeScreen() {
		clone.closeScreen();
	}
*/

	@Override
	public void mountEntity(Entity par1Entity) {
		clone.mountEntity(par1Entity);
	}


	@Override
	public void updateRidden() {
		clone.updateRidden();
	}

/*
	@Override
	public void preparePlayerToSpawn() {
		clone.preparePlayerToSpawn();
	}


	@Override
	protected void updateEntityActionState() {
		clone.updateEntityActionState();
	}*/


	@Override
	public void onLivingUpdate() {
		clone.onLivingUpdate();
	}


/*	@Override
	public int getScore() {
		return clone.getScore();
	}


	@Override
	public void setScore(int par1) {
		clone.setScore(par1);
	}


	@Override
	public void addScore(int par1) {
		clone.addScore(par1);
	}*/


	@Override
	public void onDeath(DamageSource par1DamageSource) {
		clone.onDeath(par1DamageSource);
	}


	@Override
	public void addToPlayerScore(Entity par1Entity, int par2) {
		clone.addToPlayerScore(par1Entity, par2);
	}


    /**
     * Called when player presses the drop item key
     */
    public EntityItem dropOneItem(boolean par1)
    {
        ItemStack stack = inventory.getCurrentItem();

        if (stack == null)
        {
            return null;
        }

        if (stack.getItem().onDroppedByPlayer(stack, this))
        {
            int count = par1 && this.inventory.getCurrentItem() != null ? this.inventory.getCurrentItem().stackSize : 1;
            return ForgeHooks.onPlayerTossEvent(this, inventory.decrStackSize(inventory.currentItem, count));
        }

        return null;
    }

    /**
     * Args: itemstack - called when player drops an item stack that's not in his inventory (like items still placed in
     * a workbench while the workbench'es GUI gets closed)
     */
    public EntityItem dropPlayerItem(ItemStack par1ItemStack)
    {
        return ForgeHooks.onPlayerTossEvent(this, par1ItemStack);
    }


	@Override
	public EntityItem dropPlayerItemWithRandomChoice(ItemStack par1ItemStack,
			boolean par2) {
		return clone.dropPlayerItemWithRandomChoice(par1ItemStack, par2);
	}


	@Override
	public void joinEntityItemWithWorld(EntityItem par1EntityItem) {
		clone.joinEntityItemWithWorld(par1EntityItem);
	}


	@Override
	public float getCurrentPlayerStrVsBlock(Block par1Block, boolean par2) {
		return clone.getCurrentPlayerStrVsBlock(par1Block, par2);
	}


	@Override
	public float getCurrentPlayerStrVsBlock(Block par1Block, boolean par2,
			int meta) {
		return clone.getCurrentPlayerStrVsBlock(par1Block, par2, meta);
	}


	@Override
	public boolean canHarvestBlock(Block par1Block) {
		return clone.canHarvestBlock(par1Block);
	}


	@Override
	public float getEyeHeight() {
		return clone.getEyeHeight();
	}


	@Override
	protected void resetHeight() {
		clone.yOffset = 1.62f;
		this.yOffset = 1.62f;
	}


	@Override
	public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
		return clone.attackEntityFrom(par1DamageSource, par2);
	}


	@Override
	protected void damageArmor(float par1) {
		clone.damageArmor(par1);
	}


	@Override
	public int getTotalArmorValue() {
		return clone.getTotalArmorValue();
	}
/*

	@Override
	protected void damageEntity(DamageSource par1DamageSource, float par2) {
		clone.damageEntity(par1DamageSource, par2);
	}


	@Override
	public boolean interactWith(Entity par1Entity) {
		return clone.interactWith(par1Entity);
	}
*/

	@Override
	public ItemStack getCurrentEquippedItem() {
		return clone.getCurrentEquippedItem();
	}


	@Override
	public void destroyCurrentEquippedItem() {
		clone.destroyCurrentEquippedItem();
	}


	@Override
	public double getYOffset() {
		return clone.getYOffset();
	}


	@Override
	public void attackTargetEntityWithCurrentItem(Entity par1Entity) {
		clone.attackTargetEntityWithCurrentItem(par1Entity);
	}

/*
	@Override
	public void onCriticalHit(Entity par1Entity) {
		clone.onCriticalHit(par1Entity);
	}


	@Override
	public void onEnchantmentCritical(Entity par1Entity) {
		clone.onEnchantmentCritical(par1Entity);
	}
*/
/*
	@Override
	public void respawnPlayer() {
		clone.respawnPlayer();
	}
*/

	@Override
	public void setDead() {
		clone.setDead();
	}


	@Override
	public boolean isEntityInsideOpaqueBlock() {
		return clone.isEntityInsideOpaqueBlock();
	}

/*
	@Override
	public EnumStatus sleepInBedAt(int par1, int par2, int par3) {
		return clone.sleepInBedAt(par1, par2, par3);
	}


	@Override
	public float getBedOrientationInDegrees() {
		return clone.getBedOrientationInDegrees();
	}


	@Override
	public boolean isPlayerSleeping() {
		return clone.isPlayerSleeping();
	}


	@Override
	public boolean isPlayerFullyAsleep() {
		return clone.isPlayerFullyAsleep();
	}


	@Override
	public int getSleepTimer() {
		return clone.getSleepTimer();
	}


	@Override
	protected void setHideCape(int par1, boolean par2) {
		clone.setHideCape(par1, par2);
	}


	@Override
	public void addChatMessage(String par1Str) {
		clone.addChatMessage(par1Str);
	}


	@Override
	public boolean isSpawnForced() {
		return clone.isSpawnForced();
	}


	@Override
	public ChunkCoordinates getBedLocation(int dimension) {
		return clone.getBedLocation(dimension);
	}


	@Override
	public boolean isSpawnForced(int dimension) {
		return clone.isSpawnForced(dimension);
	}


	@Override
	public void setSpawnChunk(ChunkCoordinates par1ChunkCoordinates,
			boolean par2) {
		clone.setSpawnChunk(par1ChunkCoordinates, par2);
	}


	@Override
	public void setSpawnChunk(ChunkCoordinates chunkCoordinates,
			boolean forced, int dimension) {
		clone.setSpawnChunk(chunkCoordinates, forced, dimension);
	}


	@Override
	public void triggerAchievement(StatBase par1StatBase) {
		clone.triggerAchievement(par1StatBase);
	}*/

/*
	@Override
	public void addStat(StatBase par1StatBase, int par2) {
		clone.addStat(par1StatBase, par2);
	}*/


	@Override
	protected void jump() {
		clone.jump();
	}


	@Override
	public void moveEntityWithHeading(float par1, float par2) {
		clone.moveEntityWithHeading(par1, par2);
	}


	@Override
	public float getAIMoveSpeed() {
		return clone.getAIMoveSpeed();
	}

/*
	@Override
	public void addMovementStat(double par1, double par3, double par5) {
		clone.addMovementStat(par1, par3, par5);
	}*/


/*	@Override
	protected void fall(float par1) {
		clone.fall(par1);
	}*/


	@Override
	public void onKillEntity(EntityLivingBase par1EntityLivingBase) {
		clone.onKillEntity(par1EntityLivingBase);
	}


	@Override
	public void setInWeb() {
		clone.setInWeb();
	}


	@Override
	public Icon getItemIcon(ItemStack par1ItemStack, int par2) {
		return clone.getItemIcon(par1ItemStack, par2);
	}


	@Override
	public ItemStack getCurrentArmor(int par1) {
		return clone.getCurrentArmor(par1);
	}


	@Override
	public void addExperience(int par1) {
		clone.addExperience(par1);
	}


	@Override
	public void addExperienceLevel(int par1) {
		clone.addExperienceLevel(par1);
	}


	@Override
	public int xpBarCap() {
		return clone.xpBarCap();
	}


	@Override
	public void addExhaustion(float par1) {
		clone.addExhaustion(par1);
	}


	@Override
	public boolean canEat(boolean par1) {
		return par1 || clone.foodStats.needFood();
	}


	@Override
	public boolean shouldHeal() {
		return clone.shouldHeal();
	}


	@Override
	public void setItemInUse(ItemStack par1ItemStack, int par2) {
		clone.setItemInUse(par1ItemStack, par2);
	}


	@Override
	protected int getExperiencePoints(EntityPlayer par1EntityPlayer) {
		return clone.getExperiencePoints(par1EntityPlayer);
	}


	@Override
	protected boolean isPlayer() {
		return true;
	}


	@Override
	public String getEntityName() {
		return clone.getEntityName();
	}


	@Override
	public boolean getAlwaysRenderNameTagForRender() {
		return clone.getAlwaysRenderNameTagForRender();
	}



	@Override
	public ItemStack getCurrentItemOrArmor(int par1) {
		return clone.getCurrentItemOrArmor(par1);
	}


	@Override
	public ItemStack getHeldItem() {
		return clone.getHeldItem();
	}


	@Override
	public void setCurrentItemOrArmor(int par1, ItemStack par2ItemStack) {
		clone.setCurrentItemOrArmor(par1, par2ItemStack);
	}


	@Override
	public ItemStack[] getLastActiveItems() {
		return clone.getLastActiveItems();
	}


	@Override
	public Scoreboard getWorldScoreboard() {
		return clone.getWorldScoreboard();
	}


	@Override
	public Team getTeam() {
		return clone.getTeam();
	}


	@Override
	public String getTranslatedEntityName() {
		return clone.getTranslatedEntityName();
	}

	
	
	
	

}
